IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO](
	[CD_CTR_COMPRAS_GRUPO] [int] NOT NULL,
	[CD_SIGLA] [int] NOT NULL,
	[VLR_PARAMETRO] [money] NOT NULL,
	[CD_CTR_PROC] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_PARAM_COMPRAS_GRUPO_CURVA_USO] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_COMPRAS_GRUPO] ASC,
	[CD_SIGLA] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_CURVA_USO_VLR_PARAMETRO]  DEFAULT ((0)) FOR [VLR_PARAMETRO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_CURVA_USO_CD_CTR_PROC]  DEFAULT ((0)) FOR [CD_CTR_PROC]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_CURVA_USO_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PARAM_COMPRAS_GRUPO_CURVA_USO_EST_PARAM_COMPRAS_GRUPO] FOREIGN KEY([CD_CTR_COMPRAS_GRUPO])
REFERENCES [dbo].[EST_PARAM_COMPRAS_GRUPO] ([CD_CTR])

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO] CHECK CONSTRAINT [FK_EST_PARAM_COMPRAS_GRUPO_CURVA_USO_EST_PARAM_COMPRAS_GRUPO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PARAM_COMPRAS_GRUPO_CURVA_USO_EST_PARAM_COMPRAS_GRUPO_CURVA_USO] FOREIGN KEY([CD_CTR_COMPRAS_GRUPO], [CD_SIGLA])
REFERENCES [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO] ([CD_CTR_COMPRAS_GRUPO], [CD_SIGLA])

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_CURVA_USO] CHECK CONSTRAINT [FK_EST_PARAM_COMPRAS_GRUPO_CURVA_USO_EST_PARAM_COMPRAS_GRUPO_CURVA_USO]
END

